//=============================================================================
// MSMTLTeam, no difference other custom players.
//
// 
//=============================================================================
class MSMTLTeam extends MTLTeam; 

var class<MTLPlayer> UnatcoClassName;
var class<MTLPlayer> NsfClassName;

var name UnatcoClass;
var name NsfClass;

function bool ChangeTeam (Pawn Z61, int NewTeam)
{
	local Class<MTLPlayer> Z62;
	local MTLPlayer Z63;

	if (  !ApproveTeam(NewTeam) )
	{
		NewTeam=128;
	}
	if ( NewTeam == 128 )
	{
		if ( PlayerPawn(Z61) != None )
		{
			NewTeam=PlayerPawn(Z61).PlayerReplicationInfo.Team;
		} else {
			return False;
		}
	}
	if (  !Super(DeusExMPGame).ChangeTeam(Z61,NewTeam) )
	{
		return False;
	}
	Z63=MTLPlayer(Z61);
	if ( Z63 == None )
	{
		return False;
	}
	if ( NewTeam == 0 )
	{
		Z62=UnatcoClassName;
	} else {
		if ( NewTeam == 1 )
		{
			Z62=NsfClassName;
		} else {
			return False;
		}
	}
	return True;
}

// ---------------------------------------------------------------------
// Override login so we can specify our own player classes
// ---------------------------------------------------------------------
event PlayerPawn Login(string Portal, string Options, out string Error,
		       class<playerpawn> SpawnClass)
{
   local DeusExPlayer player;
   local NavigationPoint StartSpot;
   local byte InTeam;
   local DumpLocation dump;
   local int TeamOption;

   TeamOption = TEAM_UNATCO;
   if (HasOption(Options,"Team"))
   {
      TeamOption = int(ParseOption(Options,"Team"));
   }

   if (TeamOption == TEAM_AUTO)
      TeamOption = GetAutoTeam();

   if (TeamOption == TEAM_UNATCO)
      SpawnClass = UnatcoClassName;

   else if (TeamOption == TEAM_NSF)
      SpawnClass = NsfClassName;

   ChangeOption(Options, "Team", string(TeamOption));

   // Can't call Super.Login here since that forces a particular class, so
   //  we cut and paste the code (horribly breaks compatibility, but we
   //  really have no choice)

   ///////////////////////////////////////////////////////////////////////////
   // Login from DeusExMPGame
   if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
   {
     Error = TooManyPlayers;
     return None;
   }

   ///////////////////////////////////////////////////////////////////////////
   // Login from DeusExGameInfo

   // We SKIP over all of the other Login() calls and go directly to GameInfo
   //  so that we can miss all the IS bogocity
   player = DeusExPlayer(Super(GameInfo).Login(Portal, Options, Error, SpawnClass));

   // If we're traveling across a map on the same mission, 
   // nuke the player's crap and 
   
   if ((player != None) && (!HasOption(Options, "Loadgame")))
   {
     player.ResetPlayerToDefaults();
     
     dump = player.CreateDumpLocationObject();

     if ((dump != None) && (dump.HasLocationBeenSaved()))
     {
       dump.LoadLocation();

       player.Pause();
       player.SetLocation(dump.currentDumpLocation.Location);
       player.SetRotation(dump.currentDumpLocation.ViewRotation);
       player.ViewRotation = dump.currentDumpLocation.ViewRotation;
       player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);
       
       CriticalDelete(dump);
     }
     else
     {
       // Multiplayer now, defaults to Team_Unatco=0
       InTeam    = GetIntOption( Options, "Team", 0 );

       if (Level.NetMode == NM_Standalone)			
	 StartSpot = FindPlayerStart( None, InTeam, Portal );
       else
	 StartSpot = FindPlayerStart( Player, InTeam, Portal );

       player.SetLocation(StartSpot.Location);
       player.SetRotation(StartSpot.Rotation);
       player.ViewRotation = StartSpot.Rotation;
       player.ClientSetRotation(player.Rotation);
     }
   }

   player.bAutoActivate = true;

   return player;
}



defaultproperties
{
    UnatcoClassName=Class'MSMTLUNATCO'
    NsfClassName=Class'MSMTLNSF'
    DefaultPlayerClass=Class'MSMTLUNATCO'
    TeamNsfString="Communists"
    TeamUnatcoString="Markistan Troops"
}
